#!/usr/bin/perl
#
$Version = 0.11;
@ARGV = ( "../../release", "C:/Data/Websites/vb38/forum", );

# -------------------------------------------------------------------------------
# Extracts the function definitions from each file in the directory tree $argv[0]
# and cross-references against the contents of all files
#
# Usage : listfunctions.pl
#
# Note that the parsing is very primitive - it's just looking for
# strings of \w's followed by (
# -------------------------------------------------------------------------------

use strict;
use Cwd 'abs_path';
use Data::Dumper;

# Keywords we are happy to ignore...
my %phpkeys = (
    'AGAINST'      => 0,
    'AND'          => 0,
    'COUNT'        => 0,
    'IF'           => 0,
    'IN'           => 0,
    'INDEX'        => 0,
    'INT'          => 0,
    'ISNULL'       => 0,
    'KEY'          => 0,
    'LIKE'         => 0,
    'MATCH'        => 0,
    'MEDIUMINT'    => 0,
    'ON'           => 0,
    'OR'           => 0,
    'RAND'         => 0,
    'SMALLINT'     => 0,
    'SUM'          => 0,
    'USING'        => 0,
    'VALUES'       => 0,
    'VARCHAR'      => 0,
    'VERSION'      => 0,
    'WHERE'        => 0,
    'and'          => 0,
    'define'       => 0,
    'else'         => 0,
    'elseif'       => 0,
    'for'          => 0,
    'foreach'      => 0,
    'if'           => 0,
    'include'      => 0,
    'include_once' => 0,
    'or'           => 0,
    'require'      => 0,
    'require_once' => 0,
    'return'       => 0,
    'switch'       => 0,
    'while'        => 0,
    '||'           => 0,
);

# Function calls we are happy to ignore...
my %phpfuncs = (
    'array'            => 0,
    'array_diff'       => 0,
    'array_flip'       => 0,
    'array_intersect'  => 0,
    'array_key_exists' => 0,
    'array_keys'       => 0,
    'array_merge'      => 0,
    'array_reverse'    => 0,
    'array_search'     => 0,
    'array_slice'      => 0,
    'basename'         => 0,
    'chr'              => 0,
    'closedir'         => 0,
    'count'            => 0,
    'defined'          => 0,
    'empty'            => 0,
    'eval'             => 0,
    'explode'          => 0,
    'fclose'           => 0,
    'feof'             => 0,
    'fetch_array'      => 0,
    'fgets'            => 0,
    'filesize'         => 0,
    'floor'            => 0,
    'flush'            => 0,
    'fopen'            => 0,
    'fread'            => 0,
    'fstat'            => 0,
    'function_exists'  => 0,
    'fwrite'           => 0,
    'implode'          => 0,
    'in_array'         => 0,
    'ini_get'          => 0,
    'ini_set'          => 0,
    'intval'           => 0,
    'is_array'         => 0,
    'is_numeric'       => 0,
    'is_object'        => 0,
    'isset'            => 0,
    'ksort'            => 0,
    'linksadmin'       => 0,
    'linkscat'         => 0,
    'linksdebug'       => 0,
    'linksdownloads'   => 0,
    'linksentities'    => 0,
    'linksfavs'        => 0,
    'linkskeys'        => 0,
    'linkslink'        => 0,
    'linksltoc'        => 0,
    'linksltok'        => 0,
    'linksrate'        => 0,
    'linkssearch'      => 0,
    'list'             => 0,
    'max'              => 0,
    'microtime'        => 0,
    'min'              => 0,
    'num_rows'         => 0,
    'opendir'          => 0,
    'parse_url'        => 0,
    'phpversion'       => 0,
    'php_uname'        => 0,
    'pow'              => 0,
    'preg_match'       => 0,
    'preg_match_all'   => 0,
    'preg_replace'     => 0,
    'preg_split'       => 0,
    'query_first'      => 0,
    'query_read'       => 0,
    'query_write'      => 0,
    'rand'             => 0,
    'readdir'          => 0,
    'realpath'         => 0,
    'round'            => 0,
    'serialize'        => 0,
    'sort'             => 0,
    'sprintf'          => 0,
    'str_replace'      => 0,
    'strlen'           => 0,
    'strrpos'          => 0,
    'strstr'           => 0,
    'strtolower'       => 0,
    'strtr'            => 0,
    'substr'           => 0,
    'trim'             => 0,
    'uksort'           => 0,
    'unlink'           => 0,
    'unserialize'      => 0,
    'unset'            => 0,
);

# Print a header
sub header {
    my $rep = 64;
    print "\n\n";
    print '-' x $rep;
    print "\n";
    print shift @_;
    print "\n";
    print '-' x $rep;
    print "\n\n";
}

# Find all the .php files in the directory tree under the argument directory
sub findphpfiles {

    my $path     = shift(@_);
    my $root     = abs_path($path);
    my @filelist = ();
    my $DIR;

    opendir( $DIR, $root ) || die "can't opendir $root: $!";
    my @files = readdir($DIR);
    closedir $DIR;

  FILE:
    foreach my $file (@files) {
        if ( $file =~ m{^\.+$} ) {
            next FILE;
        }
        my $fullfile = $root . '/' . $file;
        if ( -d $fullfile ) {
            push @filelist, findphpfiles($fullfile);
        }
        elsif ( $fullfile =~ /\.php$/ ) {
            push @filelist, $fullfile;
        }
    }

    return @filelist;

}

my @files     = findphpfiles( $ARGV[0] );
my @calls     = ();
my %functions = ();

my $call;
my $function_name;
my $hashref;
my $line;

foreach my $file (@files) {
    my $lfile = $file;
    $lfile =~ s{^.*/}{};
    open my $THIS_FILE, "<", $file or die "Unable to open $file";
    my $linenumber = 0;
    while (<$THIS_FILE>) {

        s/\/\/.*//;
        s/^\s*(.*)\s*/$1/;

        $linenumber += 1;

        # Find the function calls - alphanum strings followed by open parenthesis
        $line = $_;
        while ( $line =~ m{(function |)([a-zA-Z]\w*)\s*\(}gsm ) {
            my $is_defn   = $1;
            my $pre_paren = $2;
            my $in_paren  = $3;

            if ( exists( $phpkeys{$pre_paren} ) ) {
                $phpkeys{$pre_paren}++;
            }
            elsif ( exists( $phpfuncs{$pre_paren} ) ) {
                $phpfuncs{$pre_paren}++;
            }
            else {
                $hashref = {
                    'lineno'  => $linenumber,
                    'line'    => $line,
                    'file'    => $lfile,
                    'func'    => $pre_paren,
                    'defined' => 0,
                    'isdefn'  => $is_defn,
                };
                push @calls, $hashref;
            }
        }

        # Find the function definitions
        $line = $_;
        while ( $line =~ m {function +([a-zA-Z]\w*)\s*\(}gsm ) {
            $functions{$1} = $lfile;
        }

    }

    close $THIS_FILE;

}

header("Functions defined locally");

header("By function");

my %filemap;

foreach my $function_name ( sort keys %functions ) {

    #    printf "%s\n", $function_name." (".$functions{$function_name}.")";
    foreach $call (@calls) {
        if ( ${$call}{'func'} eq $function_name and ${$call}{'isdefn'} ne '' ) {
            ${$call}{'defined'} = 1;
            print $function_name. "\n   defn " . ${$call}{'file'} . " line " . ${$call}{'lineno'};
            $filemap{ ${$call}{'file'} }{'defn'}{$function_name} = 1;
        }
    }
    my $thisfile = '';
    foreach $call (@calls) {
        if ( !exists( ${$call}{'defined'} ) ) {
            print "\n   ndef " . ${$call}{'file'} . " line " . ${$call}{'lineno'};
        }
        if ( ${$call}{'func'} eq $function_name and ${$call}{'isdefn'} eq '' ) {
            if ( $thisfile ne ${$call}{'file'} ) {
                print "\n   call " . ${$call}{'file'} . " line ";
                $thisfile = ${$call}{'file'};
            }
            print ' ' . ${$call}{'lineno'};
            $filemap{ ${$call}{'file'} }{'call'}{$function_name} += 1;
        }
    }
    print "\n";
}

header("By file");

foreach my $thisfile ( sort keys %filemap ) {
    print "\n" . $thisfile . "\n";
    foreach my $thisfunc ( sort keys %{$filemap{$thisfile}{'defn'}} ) {
        print "   defn $thisfunc\n";
    }
    foreach my $thisfunc ( sort keys %{$filemap{$thisfile}{'call'}} ) {
        print "   call $thisfunc\n";
    }
    print "\n";
}

my %nonlocals = ();

NONLOCAL:
foreach my $call (@calls) {
    if ( ${$call}{'defined'} > 0 ) {
        next NONLOCAL;
    }

    my $this_func = ${$call}{'func'};
    if ( !exists( $nonlocals{$this_func} ) ) {
        $nonlocals{$this_func}{'count'} = 0;
        $nonlocals{$this_func}{'file'}  = '';
    }
    $nonlocals{$this_func}{'count'}++;

}

my @vbfiles = findphpfiles( $ARGV[1] );

foreach my $vbfile (@vbfiles) {
    my $lfile = $vbfile;
    $lfile =~ s{^.*/}{};
    open my $THIS_FILE, "<", $vbfile or die "Unable to open $vbfile";
    my $linenumber = 0;
    while (<$THIS_FILE>) {
        s/\/\/.*//;
        s/^\s*(.*)\s*/$1/;

        # Find the function definitions
        $line = $_;
        while ( $line =~ m {function +([a-zA-Z]\w*)\s*\(}gsm ) {
            my $vbfunc = $1;
            foreach my $name ( keys %nonlocals ) {
                if ( $vbfunc eq $name ) {
                    $nonlocals{$name}{'file'} = $lfile;
                }
            }
        }
    }
    close $THIS_FILE;
}

header("Calls to standard functions");

foreach my $keyword ( sort keys %phpfuncs ) {
    if ( $phpfuncs{$keyword} > 0 ) {
        print $keyword. ":" . $phpfuncs{$keyword} . "\n";
    }
}

header("Calls to functions defined in VB code");

foreach my $name ( sort keys %nonlocals ) {
    if ( $nonlocals{$name}{'file'} ne '' ) {
        print $name. ":" . $nonlocals{$name}{'count'} . "  [" . $nonlocals{$name}{'file'} . "]\n";
    }
}

header("Calls to undefined functions");

foreach my $name ( sort keys %nonlocals ) {
    if ( $nonlocals{$name}{'file'} eq '' ) {
        print $name. ":" . $nonlocals{$name}{'count'} . ":" . "\n";
    }
}

